<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">

<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('template_url'); ?>/chimod_custom.css" />
<!--[If IE]>
	<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('template_url'); ?>/ie.css" />
<![endif]-->
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>

<script type="text/javascript">
<!--

function validate_form (form1)
{
    valid = true;


 	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
   	var thisEmail = document.estimate_form.email.value;
	var thisTest = document.estimate_form.test.value;

	if ( document.estimate_form.email.value == "E-Mail*" ){ valid = false; }
	if ( document.estimate_form.email.value == "" ){ valid = false; }
	if ( document.estimate_form.test.value == "?" ){ valid = false; }
	if ( document.estimate_form.test.value == "" ){ valid = false; }
	if ( document.estimate_form.phone.value == "Phone*" ){ valid = false; }
	if ( document.estimate_form.phone.value == "" ){ valid = false; }

	if (valid == false){
		window.alert ( "Please fill out the required fields." )
	}
	if (valid == true){
		if(reg.test(thisEmail) == false) {
		  window.alert('Invalid Email Address');
		  valid = false;
		  }

	}
    return valid;

}

function validate_form2 (form2)
{
    valid = true;
	valid1 = true;
	valid2 = true;


 	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
   	var thisEmail = document.estimate_form2.email.value;
	var thisTest = document.estimate_form2.test.value;

	if ( document.estimate_form2.email.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.name.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.phone.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.test.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.test.value == "?*" ){ valid1 = false; }
	if ( document.estimate_form2.budget.selectedIndex == 0 ){ valid1 = false; }
	if ( document.estimate_form2.time.selectedIndex == 0 ){ valid1 = false; }
	if ( document.estimate_form2.howhear.selectedIndex == 0 ){ valid1 = false; }

	if (!document.estimate_form2.level[0].checked &&
		!document.estimate_form2.level[1].checked &&
		!document.estimate_form2.level[2].checked) {
			valid2 = false;

	}

	if (!document.estimate_form2.project[0].checked &&
		!document.estimate_form2.project[1].checked &&
		!document.estimate_form2.project[2].checked &&
		!document.estimate_form2.project[3].checked) {
			valid3 = false;

	}

	if (valid1 == false){
		window.alert ( "Please fill out the required fields." );
		valid = false;
	}
	if (valid2 == false){
		window.alert ( "Please choose from Building Sphere." );
		valid = false;
	}
	if (valid3 == false){
		window.alert ( "Please choose from Project Type." );
		valid = false;
	}

	if (valid == false){

	}

	if (valid == true){
		if(reg.test(thisEmail) == false) {
		  window.alert('Invalid Email Address');
		  valid1 = false;
		  }

	}
    return valid;

}



function selectText(textField)
  {
    textField.focus();
    textField.select();
  }
//-->
</script>

</head>

<body <?php body_class(); ?>>

	<div id="header">
	    <div id="masthead">
	        <div id="branding" role="banner">
		    <div id="logo">
                        <a href="<?php echo get_option('home'); ?>/" title="Home"><img src="<?php bloginfo('template_url'); ?>/images/chicagoland_remodeling_logo.jpg" title="Chicagoland Remodeling Logo" width="295" height="79" /></a>
            	    </div>

            	    <div id="access2">
                    <?php /* Allow screen readers / text browsers to skip the navigation menu and get right to the good stuff */ ?>
		    <div class="skip-link screen-reader-text"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentyten' ); ?>"><?php _e( 'Skip to content', 'twentyten' ); ?></a>
                    </div>
		    <?php /* Our navigation menu. If one isn't filled out, wp_nav_menu falls back to wp_page_menu. The menu assiged to the primary position is the one used. If none is assigned, the menu with the lowest ID is used. */ ?>
                    <div class="rating"><?php csr_get_overall_rating(); ?></div>
                    <?php wp_nav_menu( array( 'menu' => 'secondary', 'container_class' => 'menu-header' ) ); ?>
		    </div>

		    <div id="callus">
		        <a href="tel:(708) 583-9904" onclick="ga('send', 'event', 'Mobile Call', 'Click');">(708) 583-9904</a>
		    </div>
		</div><!-- #menu2 -->
	</div>
    </div>

<!--<img id="backslider" style="width:100%;" src="https://chicagolandremodeling.com/wp-content/uploads/2012/11/slide-white.jpg" /> -->
		<?php if ( is_page_template('page_home.php') ) : ?>
                <div style="width:100% !important; max-width:100%; height:auto; position:relative; left:0; float:left" id="slider-home">
                    <?php if ( function_exists( 'meteor_slideshow' ) ) { meteor_slideshow(); } ?>
					<?php echo do_shortcode('[contact-form-7 id="782" title="Contact form 1"]'); ?>
                </div>

<div id="wrapper" class="hfeed">


	<div id="main">


				<?php /*echo do_shortcode("[wr_contactform id=799]");*/ ?>

            <?php elseif( is_page_template('page_roofing.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test1">
                    <div id="head_img">
                    <img src="<?php bloginfo('template_url'); ?>/images/roofing_home.jpg" width="613" height="218" alt="Roofing" />
                </div>
			<?php elseif( is_page_template('page_kitchen.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test2">
                <div id="head_img">
                <img src="<?php bloginfo('template_url'); ?>/images/kitchen_home.jpg" width="613" height="218" alt="Kitchen Remodeling" />
                </div>

			<?php elseif( is_page_template('page_bathroom.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test3">
                    <div id="head_img">
                <img src="<?php bloginfo('template_url'); ?>/images/bathroom_home.jpg" width="613" height="218" alt="Bathroom Remodeling" />
                </div>

			<?php elseif( is_page_template('page-954.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test4">
                    <div id="head_img">
                <img src="https://chicagolandremodeling.com/wp-content/uploads/2013/03/basements.jpg" width="613" height="218" alt="Basements" />
                </div>



	    <?php elseif( is_page_template('page-44.php') ) : ?>

            <?php elseif( is_page_template('page_siding.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test5">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/siding_home.jpg" width="613" height="218" alt="Siding and Windows" />
                </div>
            <?php elseif( is_page_template('page_decking.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test6">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/decking_home.jpg" width="613" height="218" alt="Decks and Porches" />
                </div>
            <?php elseif( is_page_template('page_services.php') ) : ?>

            <?php elseif( is_page_template('page_estimate.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test7">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/freeEstimate.jpg" width="613" height="218" alt="Free Estimate" />
                </div>

	    <?php elseif( is_page(979) ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test8">
                    <div id="head_img">
                   <img src="/wp-content/uploads/2017/02/bahtrom.jpg"   height="421"  alt="Chicago Remodeling" />
                </div>
	    <?php elseif( is_page(983) ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test9">
                    <div id="head_img">
                   <img src="/wp-content/uploads/2017/02/living.jpg"   height="421"  alt="Chicago Remodeling" />
                </div>
	    <?php elseif( is_page(981) ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test10">
                    <div id="head_img">
                   <img src="/wp-content/uploads/2017/02/18893McSweeney_after-11.jpg"   height="421"  alt="Chicago Remodeling" />
                </div>
	    <?php elseif( is_page(672) ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;" class="header-pages test11">
                    <div id="head_img">
                   <img src="/wp-content/uploads/2017/02/18893McSweeney_after-11.jpg"   height="421"  alt="Chicago Remodeling" />
                </div>
            <?php elseif( is_page(32) ) : ?>

                </div>
            <?php elseif( is_page(40) ) : ?>

                </div>
             <?php elseif( is_page(44) ) : ?>

             <?php elseif( in_category(20) ) : ?>
                <div style="width:908px;" class="header-pages single-blog-header">
                    <div id="head_img">

                    <?php if ( has_post_thumbnail() ) {
					the_post_thumbnail('full');
                    echo get_post(get_post_thumbnail_id())->post_excerpt;
					} else { ?>
					<img src="<?php bloginfo('template_url'); ?>/images/default_home.jpg" width="613" height="218" alt="Chicago Remodeling" />
					<?php } ?>
               </div>

            <?php elseif( is_single( /* array ( 231,233,234,239,241,243,246,250,252,254,260,264 ) */ )) : ?>
                <div style="width:908px; height:257px;" class="header-pages test12">
                    <div id="head_img">

                    <?php if ( has_post_thumbnail() ) {
					the_post_thumbnail('large');
                    echo get_post(get_post_thumbnail_id())->post_excerpt;
					} else { ?>
					<img src="<?php bloginfo('template_url'); ?>/images/default_home.jpg" width="613" height="218" alt="Chicago Remodeling" />
					<?php } ?>




                </div>

            <?php elseif( is_single() && in_category( array( 'roofing', 'kitchen', 'decking', 'siding', 'bathroom' ))  && has_post_thumbnail()  ) : ?>
                <div style="width:908px; height:257px;" class="header-pages test13">
                    <div id="head_img">
                    <?php the_post_thumbnail('full');
                    echo get_post(get_post_thumbnail_id())->post_excerpt; ?>
                </div>

			<?php else : ?>
            	 <div style="width:908px; height:auto; margin-bottom:20px; " class="header-pages test14">
                    <div id="head_img" style="padding-bottom: 3px;">
                   <img src="/wp-content/uploads/2017/02/18893McSweeney_after-11.jpg"   height="421"  alt="Chicago Remodeling" />
                </div>


            <?php endif ?>


 		<?php if ( is_page_template('page_home.php') ) : ?>


		<?php elseif( is_page(44) ) : ?>

		<?php elseif( is_page(40) ) : ?>

		<?php elseif( is_page(32) ) : ?>
        <?php elseif( is_page(672) ) : ?>
		<?php elseif( is_page_template('page_services.php') ) : ?>
		<?php elseif( in_category(20) ) : ?>


		<?php else : ?>
        	<div class="contact-form-sub">
            <?php echo do_shortcode('[contact-form-7 id="1382" title="Contact form subpages"]'); ?>
            </div>
			</div>

        <?php endif ?>

