<?php
/**
 * Template Name: Kitchen Page
 *
 * A custom page template with sidebars left and right.
 * Selectable from a dropdown menu on the edit page screen.
 *
 * @package WordPress
 * @subpackage Twenty Ten
 * @since 3.0.0
 */

get_header(); ?>

		<div id="container" class="two-column">
                <div id="content" role="main">
    			<h1 class="entry-title"><?php the_title(); ?></h1>
                <?php
                /* Run the loop to output the page.
                 * If you want to overload this in a child theme then include a file
                 * called loop-page.php and that will be used instead.
                 */
                get_template_part( 'loop', 'page' );
                ?>
    
                </div><!-- #content -->
			</div><!-- #container -->

			<div id="content_menu2">
            	<h2>Related Services</h2>
                <hr />
                <ul>
                
				<?php 
				$args = array( 'category_name' => 'kitchen-menu', 'orderby'  => 'title', 	'order' => 'ASC', 'posts_per_page'=>-1, 'numberposts'=>-1 );
				$menu2posts = get_posts( $args ); 					
                    
					foreach( $menu2posts as $post ) : 
                        setup_postdata($post); ?>
						<li><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" target="_self"><?php echo the_title(); ?></a></li>
                		<hr />
                 <?php endforeach; ?> 
                 </ul> 
            </div>

			<div id="container2">
                <div id="content2">
                    <?php 
                        the_secondary_content( 'Content Area Two' );
                    ?>
                </div>
                <div id="content3">
                
                <?php                     
                    $customposts = get_posts('category_name=kitchen' ); 
					
                    
                    foreach( $customposts as $post ) : 
                        setup_postdata($post); ?>
                    
                        <div class="post_box" >
                         <div class="innerbox">
                         <h2 class="entry-title"><?php the_title(); ?></h2>
                         <div style="margin-left:-30px;">
                               <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
                               <?php the_post_thumbnail(array(333,245)); ?>
                               </a>
                               <?php echo get_post(get_post_thumbnail_id())->post_excerpt; ?>
                         </div>
                         <?php the_excerpt(); ?>
                        </div>
                    	</div>     
                    
                    <?php endforeach; ?> 
                               
                </div>                
                
            </div><!-- #container2 -->

		
<?php get_footer(); ?>
